 ; Ŀ
 ;   Pur - do a variety of things to a number of entity types.             
 ;   Copyright 1994, 1995, 1997, 1998, 2005 - 2010 by Rocket Software Ltd. 
 ;   Does "the right to keep and bear arms" include nuclear weapons?       
 ; 

 ; Ŀ
 ;   Subroutine AA: see if a point lies on a circle, polyline box or arc.  
 ;   Returns a centre point if so, an ename if there was an entity but     
 ;   not a usable one, and nil otherwise.                                  
 ;   Called by Tea\Psork.                                                  
 ; 
 (DEFUN AA (pa / 10th pa ss enam entt typ pmid ten cl num ptlist cen)
  (setq 10th (/ (misps) 10))
  (setq ss (ssget pa '((-4 . "<or") (0 . "polyline") (0 . "arc")
                                    (0 . "circle") (-4 . "or>"))))
  (if ss
      (progn
           (setq esav (setq enam (ssname ss 0)))
           (setq entt (entget enam))
           (setq typ (cdr (assoc 0 entt)))
           (cond ((= typ "CIRCLE")
                  (setq pmid (cdr (assoc 10 entt))))
                 ((= typ "ARC")
                  (setq pmid (cdr (assoc 10 entt))))
                 ((= typ "POLYLINE")
                  (setq ten (cdr (assoc 10 (entget (entnext enam)))))
                  (if (= 1 (logand 1 (cdr (assoc 70 entt))))
                      (setq cl "/CL")
                      (setq cl "/OP"))
                  (while (/= "SEQEND" (setq typ (cdr (assoc 0 (setq entt
                                       (entget (setq enam (entnext enam))))))))
                         (if (= typ "VERTEX")
                             (setq ptlist (append ptlist
                                               (list (cdr (assoc 10 entt)))))))
                  (setq num (length ptlist))
                  (setq first (car ptlist))
                  (setq lastt (last ptlist))
                  (if (or (and (= cl "/OP") (= num 5) (equal first lastt 10th))
                          (and (= cl "/CL") (= num 4)))
                      (progn
                           (setq other (nth 2 ptlist))
                           (setq angg (angle first other))
                           (setq dist (distance first other))
                           (setq pmid (polar first angg (/ dist 2)))))))))
 (if pmid pmid esav))
 ; Ŀ
 ;   AA end.                                                               
 ; 

 ; Ŀ
 ;   Bazang - given a list of three points, find the angle between a       
 ;   line from the first one to a line between the two others.             
 ;   Arguments: Ptlist, a list of three points.                            
 ;              Colo, a grdraw colour for test lines, ignore if nil.       
 ;   Calls nothing.                                                        
 ;   Returns a list: the angle difference and the angle between the first  
 ;   point and the point midway between the two others.                    
 ; 
 (DEFUN BAZANG (ptlist colo / pa pb pc basex basey basez base arang bangle)
  (setq pa (car ptlist))
  (setq pb (cadr ptlist))
  (setq pc (caddr ptlist))
 ; Ŀ
 ;   Get the middle of the side defined by the pb and pc.                  
 ; 
  (setq basex (/ (+ (car pb) (car pc)) 2))
  (setq basey (/ (+ (cadr pb) (cadr pc)) 2))
  (setq basez (/ (+ (caddr pb) (caddr pc)) 2))
  (setq base (list basex basey basez))  ; middle of back edge
 ; Ŀ
 ;   Get the angle from pa to the middle of the opposite side.             
 ; 
  (setq arang (angle pa base))
 ; Ŀ
 ;   Get the opposite side angle (pb to pc).                               
 ; 
  (setq bangle (angle pb pc))
 ; Ŀ
 ;   Make some nice test graphic lines.                                    
 ; 
  (if colo
      (progn
           (grdraw pa base colo)
           (grdraw pb pc colo)))
 ; Ŀ
 ;   Return the smallest difference between the two angles.                
 ; 
 (list (abs (rem (- arang bangle) pi)) arang))
 ; Ŀ
 ;   Bazang end.                                                           
 ; 

 ; Ŀ
 ;   Blinc - move a block so that the largest circle in it touches the     
 ;   end of a line.                                                        
 ;   Calls Circ, returns nothing.                                          
 ;   Takes three arguments: Ppt, the pick point.                           
 ;                          Bloc, the block ename.                         
 ;                          Linnam, the line enam.                         
 ; 
 (DEFUN BLINC (ppt bloc linnam / lin aa bb circa blint blex bly blz rota grsub
                                                    cen radish dist ang newcen)
  (setq lin (entget linnam))
  (setq aa (cdr (assoc 10 lin)))                      ; line start
  (setq bb (cdr (assoc 11 lin)))                      ; line end
  (setq circa (entget bloc))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 circa)))          ; insertion point
  (setq blex (cdr (assoc 41 circa)))           ; X scale
  (setq bly (cdr (assoc 42 circa)))            ; Y scale
  (setq blz (cdr (assoc 43 circa)))            ; Z scale
  (setq rota (cdr (assoc 50 circa)))           ; rotation
  (setq grsub (circ circa))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset centre from ins.
          (setq radish (car grsub))            ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
 ; (print blex)
 ; (print bly)
          (if (not (equal (abs blex) (abs bly) 0.0001)) ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
                   (setq radish (* radish (abs blex))) ; radius x scale
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Now move the block to the end of the line.                            
 ;   new centre = polar end angle radius                                   
 ; 
                   (if (> (distance aa ppt) (distance bb ppt))
                       (setq newcen (polar bb (angle aa bb) radish))
                       (setq newcen (polar aa (angle bb aa) radish)))
                   (command "move" bloc "" cen newcen)))))
 (princ))
 ; Ŀ
 ;   Subroutine blinc end.                                                 
 ; 

 ; Ŀ
 ;   Bock: find the box bounding the selection set of text or attdef       
 ;   entities which is passed as the sole argument.                        
 ;   Called by Tea.                                                        
 ; 
 (DEFUN BOCK (ss / num enam typ entt mxlst xmax xmin ymax ymin pl)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (setq mxlst (cron enam 0))
         (if xmax
             (setq xmax (max xmax (car mxlst)))
             (setq xmax (car mxlst)))
         (if xmin
             (setq xmin (min xmin (cadr mxlst)))
             (setq xmin (cadr mxlst)))
         (if ymax
             (setq ymax (max ymax (caddr mxlst)))
             (setq ymax (caddr mxlst)))
         (if ymin
             (setq ymin (min ymin (cadddr mxlst)))
             (setq ymin (cadddr mxlst))))
  (list (list xmin ymin) (list xmax ymax)))
 ; Ŀ
 ;   Bock end.                                                             
 ; 

 ; Ŀ
 ;   Bzirk - move a block to the centre of a circle in another block (if   
 ;   it contains one.)                                                     
 ;   Calls Circ, returns nothing.                                          
 ;   Takes two arguments:   Bloc1, the ename of the block to move.         
 ;                          Bloc2, the ename of the stationary block.      
 ; 
 (DEFUN BZIRK (bloc1 bloc2 / b1dat b2dat blint blex bly blz rota grsub cen
                                                     radish dist ang ss pa)
  (setq b1dat (entget bloc1))
  (setq b2dat (entget bloc2))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 b2dat)))          ; insertion point
  (setq blex (cdr (assoc 41 b2dat)))           ; X scale
  (setq bly (cdr (assoc 42 b2dat)))            ; Y scale
  (setq blz (cdr (assoc 43 b2dat)))            ; Z scale
  (setq rota (cdr (assoc 50 b2dat)))           ; rotation
  (setq grsub (circ b2dat))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset of centre from ins.
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (not (equal (abs blex) (abs bly) 0.00001)) ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Now move the first block to the centre of the circle.                 
 ; 
                   (setq pa (cdr (assoc 10 b1dat)))
                   (mover pa cen bloc1)))))
 (princ))
 ; Ŀ
 ;   Subroutine Bzirk end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Circ: find the appropriate circle in a block definition.   
 ;   Takes one argument, the block head data.                              
 ;   Returns Grsub, apparently a list of the radius and centre of the      
 ;   largest circle in the block definition, or nil if there are none.     
 ;                                                                         
 ;   Bear in mind that the ten point is an offset from the block           
 ;   insertion point, it must be moved and scaled with the block.          
 ; 
 (DEFUN CIRC (blnam / blok namm entt clist grsub sub grdiam num)
  (setq blnam (cdr (assoc 2 blnam)))        ; block definition name
 ; Ŀ
 ;   Find the block definition in the block table.                         
 ; 
  (setq blok (tblsearch "block" blnam))     ; head data from table
  (setq namm (cdr (assoc -2 blok)))         ; first ename after head
 ; Ŀ
 ;   The 10 association code from the subentity data represents an offset  
 ;   from the insertion point.                                             
 ; 
  (if (member (cdr (assoc 0 (setq entt (entget namm)))) '("ARC" "CIRCLE"))
 ; Ŀ
 ;   If the entity was a circle then append the centre point and radius    
 ;   to the list for later appraisal.                                      
 ; 
      (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                                    (cdr (assoc 10 entt)))))))
 ; Ŀ
 ;   Note: entnext returns nil after the last entity in a block            
 ;   definition.                                                           
 ; 
  (while (setq namm (entnext namm))          ; next subentity ename
         (if (member (cdr (assoc 0 (setq entt (entget namm))))
                    '("ARC" "CIRCLE"))
 ; Ŀ
 ;   If the subentity was a circle then append the centre point and        
 ;   radius to the list for later appraisal.                               
 ; 
         (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                               (cdr (assoc 10 entt))))))))
 ; Ŀ
 ;   Should now have a list of lists: centre and radius for each circle    
 ;   in the block.  If the block contained no circles then clist will be   
 ;   nil and the the routine should end.                                   
 ; 
 ; Ŀ
 ;   Now find the largest circle (assumed to be the outline.)              
 ;   More complex criteria can be considered, but 99% of the time there    
 ;   will only be one circle.  It is not realistically possible to         
 ;   anticipate the circumstances which would lead to the use of this      
 ;   routine on a block containing multiple or offset circles, and it is   
 ;   impossible to foresee what the design of the block would be.          
 ; 
 ; Ŀ
 ;   If there is only one circle in the block, use it.                     
 ; 
  (cond ((= (length clist) 1)
         (setq grsub (car clist)))
 ; Ŀ
 ;   If there are > 1.                                                     
 ; 
        ((> (length clist) 1)
         (setq sub (nth 0 clist))
         (setq grsub sub)
         (setq grdiam (car sub))
         (setq num 1)
         (while (setq sub (nth num clist))
                (if (> (car sub) grdiam)
                    (progn
                        (setq grsub sub)
                        (setq grdiam (car sub))))
                (setq num (1+ num)))))
 grsub)
 ; Ŀ
 ;   Subroutine Circ end.                                                  
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Ctc - move a circle to touch another.                                 
 ;   Takes two arguments: C1nam and C2nam, the two circle enames.          
 ;                        Arrnam, the Arrow (solid) ename.                 
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN CTC (c1nam c2nam / c1 c2 rad1 rad2 cen1 cen2 dist angg movdis)
  (setq c1 (entget c1nam))
  (setq c2 (entget c2nam))
  (setq rad1 (cdr (assoc 40 c1)))
  (setq rad2 (cdr (assoc 40 c2)))
  (setq cen1 (cdr (assoc 10 c1)))
  (setq cen2 (cdr (assoc 10 c2)))
  (setq dist (distance cen1 cen2))
  (setq angg (angle cen1 cen2))
  (setq movdis (- dist (+ rad1 rad2)))
  (command "move" c1nam "" cen1 (polar cen1 angg movdis))
 (princ))
 ; Ŀ
 ;   Ctc end.                                                              
 ; 

 ; Ŀ
 ;   Grizz - a replacement for the entsel function - returns a list in the 
 ;   (ename point) format unless there was no entity at that point, in     
 ;   which case (nil point) is returned.                                   
 ;   Takes one argument, a prompt string.                                  
 ; 
 (DEFUN GRIZZ (prom / pa ss)
  (write-line prom)
  (while (and (setq pa (grread t 5 2))
              (/= (car pa) 3)))
  (if (setq ss (ssget (setq pa (cadr pa))))
      (list (ssname ss 0) pa)
      (list () pa)))
 ; Ŀ
 ;   Grizz end.                                                            
 ; 

 ; Ŀ
 ;   Larr -  Move one end of a line to hit a solid, rotate the solid to    
 ;   match the line angle.                                                 
 ;   Takes two arguments: Linam, the line ename.                           
 ;                        Arrnam, the Arrow (solid) ename.                 
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN LARR (linam arrnam / lin arr arrang tip end1 end2 other linang diff)
  (setq lin (entget linam))
 ; Ŀ
 ;   Call Triarp to get the arrowhead tip and angle.                       
 ; 
  (if (setq arrang (triarp arrnam))
      (progn
           (setq tip (car arrang))
           (setq arrang (cadr arrang))
 ; Ŀ
 ;   Find the line end closest to the arrow point and move it there.       
 ; 
           (setq end1 (cdr (assoc 10 lin)))      ; line start
           (setq end2 (cdr (assoc 11 lin)))      ; line end
           (if (> (distance tip end1) (distance tip end2))
               (progn
                    (entmod (subst (cons 11 tip) (assoc 11 lin) lin))
                    (setq other end1))
               (progn
                    (entmod (subst (cons 10 tip) (assoc 10 lin) lin))
                    (setq other end2)))
 ; Ŀ
 ;   Calculate the new line angle.                                         
 ; 
           (setq linang (angle tip other))
 ; Ŀ
 ;   Rotate the arrowhead to match the line.                               
 ; 
           (setq diff (- arrang linang))
           (setq diff (* (/ 180 pi) diff))
           (setq diff (/ diff 50))
           (repeat 50 (command "rotate" arrnam "" tip (- diff))))
 ; Ŀ
 ;   If on the other hand Arr wasn't an arrowhead...                       
 ; 
      (prompt (strcat "\nThat was a solid, but it wasn't a real"
                      " arrowhead.  Please consult your manual.")))
 (princ))
 ; Ŀ
 ;   Larr end.                                                             
 ; 

 ; Ŀ
 ;   Leab - make a leader perpendicular to a circle in a block.            
 ;   Calls Circ and Tentt, returns nothing.                                
 ;   Takes three arguments: Ppt, the pick point.                           
 ;                          Bloc, the block ename.                         
 ;                          Leanam, the leader ename.                      
 ; 
 (DEFUN LEAB (ppt leanam bloc / lin aa bb circa blint blex bly blz rota grsub
                                           cen radish dist ang disc crang rim)
  (setq lin (entget leanam))
 ; Ŀ
 ;   Get the leader points.                                                
 ; 
  (setq lepts (tentt leanam))
  (setq aa (car lepts))               ; leader start
  (setq bb (cadr lepts))              ; next leader point
  (setq circa (entget bloc))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 circa)))          ; insertion point
  (setq blex (cdr (assoc 41 circa)))           ; X scale
  (setq bly (cdr (assoc 42 circa)))            ; Y scale
  (setq blz (cdr (assoc 43 circa)))            ; Z scale
  (setq rota (cdr (assoc 50 circa)))           ; rotation
  (setq grsub (circ circa))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset centre from ins.
          (setq radish (car grsub))            ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (not (equal (abs blex) (abs bly) 0.00001)) ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
                   (setq radish (* radish (abs blex))) ; radius x scale
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Make the leader touch the circle.                                     
 ; 
                   (setq disc (distance bb cen))   ; line/circle dist.
                   (setq crang (angle bb cen))     ; and angle
                   (setq rim (polar bb crang (- disc radish)))
                   (entmod (subst (cons 10 rim) (cons 10 aa) lin))))))
 (princ))
 ; Ŀ
 ;   Subroutine Leab end.                                                  
 ; 

 ; Ŀ
 ;   Tentt - make an entity into a list of location points.                
 ;   Argument: Enam, an entity name.                                       
 ;   Returns a list of point lists.                                        
 ;   Calls nothing, but carries a nice cell phone.                         
 ; 
 (DEFUN TENTT (enam / entt num sub gnu)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (member (car sub) '(10 11 12 13 14))
             (setq gnu (cons (cdr sub) gnu))))
 (reverse gnu))
 ; Ŀ
 ;   Tentt end.                                                            
 ; 

 ; Ŀ
 ;   Lins - make a line perpendicular to a circle in a block.              
 ;   Calls Circ, returns nothing.                                          
 ;   Takes three arguments: Ppt, the pick point.                           
 ;                          Bloc, the block ename.                         
 ;                          Linnam, the line enam.                         
 ; 
 (DEFUN LINS (ppt linnam bloc / lin aa bb circa blint blex bly blz rota grsub
                                           cen radish dist ang disc crang rim)
  (setq lin (entget linnam))
  (setq aa (cdr (assoc 10 lin)))               ; line start
  (setq bb (cdr (assoc 11 lin)))               ; line end
  (setq circa (entget bloc))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 circa)))          ; insertion point
  (setq blex (cdr (assoc 41 circa)))           ; X scale
  (setq bly (cdr (assoc 42 circa)))            ; Y scale
  (setq blz (cdr (assoc 43 circa)))            ; Z scale
  (setq rota (cdr (assoc 50 circa)))           ; rotation
  (setq grsub (circ circa))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset centre from ins.
          (setq radish (car grsub))            ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (not (equal (abs blex) (abs bly) 0.00001)) ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
                   (setq radish (* radish (abs blex))) ; radius x scale
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Now make the line touch the circle.                                   
 ; 
                   (if (> (distance aa ppt) (distance bb ppt))
                       (progn
                            (setq disc (distance aa cen))   ; line/circle dist.
                            (setq crang (angle aa cen))     ; and angle
                            (setq rim (polar aa crang (- disc radish)))
                            (entmod (subst (cons 11 rim) (assoc 11 lin) lin)))
                       (progn
                            (setq disc (distance bb cen))   ; line/circle dist.
                            (setq crang (angle bb cen))     ; and angle
                            (setq rim (polar bb crang (- disc radish)))
                            (entmod (subst (cons 10 rim)
                                           (assoc 10 lin) lin))))))))
 (princ))
 ; Ŀ
 ;   Subroutine Lins end.                                                  
 ; 

 ; Ŀ
 ;   Mcirc - move a circle to the end of a line.                           
 ;   Takes three arguments: Ppt, the pick point on the line.               
 ;                          Circ, the circle ename.                        
 ;                          Lin, the line ename.                           
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN MCIRC (ppt circ lin / aa bb cen radish crang newpt)

  (setq lin (entget lin))
  (setq circ (entget circ))
  (setq aa (cdr (assoc 10 lin)))                  ; line start
  (setq bb (cdr (assoc 11 lin)))                  ; line end
  (setq cen (cdr (assoc 10 circ)))                ; centre of circle
  (setq radish (cdr (assoc 40 circ)))             ; circle radius
  (if (< (distance aa ppt) (distance bb ppt))
      (progn
           (setq crang (angle bb aa))             ; line angle
           (setq newpt (polar aa crang radish)))
      (progn
           (setq crang (angle aa bb))             ; line angle
           (setq newpt (polar bb crang radish))))
  (entmod (subst (cons 10 newpt) (assoc 10 circ) circ))
 (princ))
 ; Ŀ
 ;   Mcirc end.                                                            
 ; 

 ; Ŀ
 ;   Mover - move an ss from one point to another while rotating it 360    
 ;   degrees.  Takes three arguments, a base point, a new point, and the   
 ;   ss name.  Returns nothing of use.                                     
 ;   Called by Tea.                                                        
 ; 
 (DEFUN MOVER (pa gnupt ss / dist angg)
  (setq jumps 30)
  (setq dist (/ (distance pa gnupt) jumps))
  (setq angg (angle pa gnupt))
  (repeat jumps
          (command ".move" ss "" "0,0" (polar (list 0 0) angg dist))
          (command ".rotate" ss "" pa (/ 360.0 jumps))
          (setq pa (polar pa angg dist))))
 ; Ŀ
 ;   Mover end.                                                            
 ; 

 ; Ŀ
 ;   Perox - error handler.                                                
 ; 
 (DEFUN PEROX (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
  (setvar "snapmode" snapp)
  (setvar "osmode" osmo)
  (setvar "angbase" angbas)
  (if shk (print shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Perox end.                                                            
 ; 

 ; Ŀ
 ;   Psork - call AA to get the centre of a circle, polyline box or an     
 ;   arc if one is found under the pick point or another corner and hence  
 ;   a centrepoint if not.                                                 
 ;   Called by Tea.  Calls AA.                                             
 ; 
 (DEFUN PSORK (/ ll pmid ur)
  (if (setq ll (getpoint "Entity/Corner point: "))
      (progn
           (setq pmid (aa ll))
           (if (or (null pmid) (= (type pmid) 'ENAME))
               (progn
                    (setq ur (getcorner ll "\nOther: "))
                    (setq pmid (polar ll (angle ll ur)
                                                (/ (distance ll ur) 2.0)))))))
 pmid)
 ; Ŀ
 ;   Psork end.                                                            
 ; 

 ; Ŀ
 ;   Rarr -  Move an arrowhead to the end of a line, rotate the arrowhead  
 ;   to match the line angle.                                              
 ;   Takes two arguments: Linam, the line ename.                           
 ;                        Arrnam, the Arrow (solid) ename.                 
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN RARR (arrnam linam / lin aa bb arr tip tip2 end1 end2 first other
                    linang base1 base2 basex basey basez base arrang diff)
  (setq lin (entget linam))
 ; Ŀ
 ;   Call Triarp to get the arrowhead tip and angle.                       
 ; 
  (if (setq arrang (triarp arrnam))
      (progn
           (setq tip (car arrang))
           (setq arrang (cadr arrang))
 ; Ŀ
 ;   Find the line end closest to the arrow point, move the arrow there.   
 ; 
           (setq end1 (cdr (assoc 10 lin)))      ; line start
           (setq end2 (cdr (assoc 11 lin)))      ; line end
           (if (> (distance tip end1) (distance tip end2))
               (progn
                    (command "move" arrnam "" tip end2)
                    (setq first end2)
                    (setq other end1))
               (progn
                    (command "move" arrnam "" tip end1)
                    (setq first end1)
                    (setq other end2)))
 ; Ŀ
 ;   Calculate the new line angle.                                         
 ; 
           (setq linang (angle first other))
 ; Ŀ
 ;   And rotate the arrowhead to match.                                    
 ; 
           (setq diff (- arrang linang))
           (setq diff (* (/ 180 pi) diff))
           (setq diff (/ diff 50))
           (repeat 50 (command "rotate" arrnam "" first (- diff))))
 ; Ŀ
 ;   If on the other hand Arr wasn't an arrowhead...                       
 ; 
      (prompt (strcat "\nThat was a solid, but it wasn't a real"
                      " arrowhead.  Please consult your manual.")))
 (princ))
 ; Ŀ
 ;   Rarr end.                                                             
 ; 

 ; Ŀ
 ;   Tanj - make a line perpendicular to a circle.                         
 ;   Takes three arguments: Ppt, the pick point on the line.               
 ;                          Lin, the line ename.                           
 ;                          Circ, the circle ename.                        
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN TANJ (ppt lin circ / aa bb cen radish disc crang rim)
  (setq lin (entget lin))
  (setq circ (entget circ))
  (setq aa (cdr (assoc 10 lin)))                  ; line start
  (setq bb (cdr (assoc 11 lin)))                  ; line end
  (setq cen (cdr (assoc 10 circ)))                ; centre of circle
  (setq radish (cdr (assoc 40 circ)))             ; circle radius
  (if (> (distance aa ppt) (distance bb ppt))
      (progn
           (setq disc (distance aa cen))                   ; line/circle dist.
           (setq crang (angle aa cen))                     ; and angle
           (setq rim (polar aa crang (- disc radish)))     ; contact point
           (entmod (subst (cons 11 rim) (assoc 11 lin) lin)))
      (progn
           (setq disc (distance bb cen))                   ; line/circle dist.
           (setq crang (angle bb cen))                     ; and angle
           (setq rim (polar bb crang (- disc radish)))     ; contact point
           (entmod (subst (cons 10 rim) (assoc 10 lin) lin))))
 (princ))
 ; Ŀ
 ;   Tanj end.                                                             
 ; 

 ; Ŀ
 ;   Erine - make a leader perpendicular to a circle or an arc.            
 ;   Takes three arguments: Ppt, the pick point on the line.               
 ;                          Lenam, the leader ename.                       
 ;                          Circ, the circle ename.                        
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN ERINE (ppt lenam circ / aa bb cen radish disc crang rim)
  (setq lin (entget lenam))
  (setq circ (entget circ))
 ; Ŀ
 ;   Get the leader points.                                                
 ; 
  (setq lepts (tentt lenam))
  (setq aa (car lepts))                         ; leader start
  (setq bb (cadr lepts))                        ; next leader point
  (setq cen (cdr (assoc 10 circ)))              ; centre of circle
  (setq radish (cdr (assoc 40 circ)))           ; circle radius
  (setq disc (distance bb cen))                 ; line/circle dist.
  (setq crang (angle bb cen))                   ; and angle
  (setq rim (polar bb crang (- disc radish)))   ; contact point
  (entmod (subst (cons 10 rim) (cons 10 aa) lin))
 (princ))
 ; Ŀ
 ;   Erine end.                                                            
 ; 

 ; Ŀ
 ;   Tea - centre justify an ss of text or a block, move to the middle of  
 ;   a box, arc, or circle.                                                
 ;   Takes one argument, an ss of text and attributes or containing        
 ;   a single block.                                                       
 ;   Computers make us more efficient, so we can have tea.                 
 ; 
 (DEFUN TEA (ss / blip dimscl ss pts ll ur pa pa1 rad)
 ; Ŀ
 ;   If the ss contained a single block, move it.                          
 ; 
  (cond ((and ss (= 1 (sslength ss))
              (= "INSERT" (cdr (assoc 0 (entget (ssname ss 0))))))
         (setq pa1 (cdr (assoc 10 (entget (ssname ss 0)))))
         (setq pmid (psork))
         (mover pa1 pmid ss))
 ; Ŀ
 ;   Otherwise remove all blocks from the ss and reposition it.            
 ; 
        (ss
         (command "select" ss "")
         (setq ss (ssget "P" '((-4 . "<or") (0 . "text")
                                             (0 . "attdef") (-4 . "or>"))))
         (setq pmid (psork))
         (vbcx ss pmid pmid)
         (setq pts (bock ss))
         (setq ll (car pts))
         (setq ur (cadr pts))
         (setq pa1 (polar ll (angle ll ur)
                             (setq rad (/ (distance ll ur) 2.0))))
         (mover pa1 pmid ss)))
 (princ))
 ; Ŀ
 ;   Tea end.                                                              
 ; 

 ; Ŀ
 ;   Triarp - see if a solid is triangular, if so return the endpoint      
 ;   and the angle to the middle of the opposite side.                     
 ;   Arguments: Arrnam, the solid ename.                                   
 ;   Calls Bazang.                                                         
 ;   Returns a point point and an angle or nil.                            
 ; 
 (DEFUN TRIARP (arrnam / arr plist num pa gnulis angg arang thangl axang panu)
 ; Ŀ
 ;   If the user ends the solid command after three points then the 12     
 ;   and 13 groups are the same point.  On the other hand, they may have   
 ;   just dragged one point onto another, so you can't assume this.        
 ; 
  (setq arr (entget arrnam))
  (setq plist (list (cdr (assoc 10 arr)) (cdr (assoc 11 arr))
                    (cdr (assoc 12 arr)) (cdr (assoc 13 arr))))
 ; Ŀ
 ;   Make a new list without duplicate points.                             
 ; 
  (setq num 0)
  (while (setq pa (nth num plist))
         (setq num (1+ num))
         (if (not (member pa gnulis))
             (setq gnulis (cons pa gnulis))))
 ; Ŀ
 ;   Find the point for which a line between it and the midpoint of the    
 ;   opposite side is closest to making a right angle with the opposite    
 ;   side.                                                                 
 ; 
  (if (= (length gnulis) 3)
      (progn
           (repeat 3
                   (setq angg (bazang gnulis nil))
                   (setq arang (cadr angg))
                   (setq angg (car angg))
                   (setq angg (abs (- angg (/ pi 2))))
                   (if (or (null thangl) (< angg thangl))
                       (progn
                            (setq thangl angg)
                            (setq axang arang)
                            (setq panu (car gnulis))))
                   (setq gnulis (cons (last gnulis)
                                      (reverse (cdr (reverse gnulis))))))
 ;         (grdraw panu (polar panu axang 12) 142)
 ; Ŀ
 ;   Return a list of the point and the angle to the back midpoint or nil. 
 ; 
           (list panu axang))))
 ; Ŀ
 ;   Triarp end.                                                           
 ; 

 ; Ŀ
 ;   Ur - see if a solid is triangular, if so return the endpoint (the     
 ;   point with two vertices) and the angle to the middle of the           
 ;   opposite side.                                                        
 ;   Arguments: Arrnam, the solid ename.                                   
 ;   Returns a point point and an angle or nil.                            
 ; 
 (DEFUN UR (arrnam / arr plist pa sharp othlst base1 base2 basex basey basez
                                                                 base arrang)
  (setq arr (entget arrnam))
  (setq plist (list (cdr (assoc 10 arr)) (cdr (assoc 11 arr))
                    (cdr (assoc 12 arr)) (cdr (assoc 13 arr))))
 ; Ŀ
 ;   If the user ends the solid command after three points then the 12     
 ;   and 13 groups are the same point.  If there are four distinct points  
 ;   then the solid isn't an arrowhead (a triangle).                       
 ; 
 ; Ŀ
 ;   See if two identical points can be found.                             
 ; 
  (while (setq pa (car plist))
         (setq plist (cdr plist))
         (cond ((equal pa sharp))
               ((member pa plist)
                (setq sharp pa))
               (t (setq othlst (cons pa othlst)))))
 ; Ŀ
 ;   If Othlst has two members and Sharp exists then it was an arrowhead.  
 ; 
  (if (and sharp (= 2 (length othlst)))
      (progn
 ; Ŀ
 ;   This being the case, get the middle of the side defined by the two    
 ;   points in Othlst - the back side, So.                                 
 ; 
           (setq base1 (car othlst))
           (setq base2 (cadr othlst))
           (setq basex (/ (+ (car base1) (car base2)) 2))
           (setq basey (/ (+ (cadr base1) (cadr base2)) 2))
           (setq basez (/ (+ (caddr base1) (caddr base2)) 2))
           (setq base (list basex basey basez))  ; middle of back edge
 ; Ŀ
 ;   Get the angle.                                                        
 ; 
           (setq arrang (angle sharp base))))
 ; Ŀ
 ;   Make a nice test graphic.  Line.                                      
 ; 
  (grdraw sharp (polar sharp arrang (* 2 (distance sharp base))) 133)
 ; Ŀ
 ;   Return a list of the point and the angle to the back midpoint or nil. 
 ; 
 (if (and sharp arrang) (list sharp arrang) ()))
 ; Ŀ
 ;   Ur end.                                                               
 ; 

 ; Ŀ
 ;   VBCX - Centre rejustify a column of text.                             
 ;   Takes three arguments: ss, the set of entities to rejustify, cc, the  
 ;   left side point, and rr, the right point.                             
 ;   Called by Tea.                                                        
 ; 
 (DEFUN VBCX (ss cc rr / xa num enam entt pty pa sp)
  (setq xa (/ (+ (car cc) (car rr)) 2))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pty (cddr (assoc 10 entt)))
         (setq pa (cons xa pty))
         (setq entt (subst (cons 72 1) (assoc 72 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbcx end.                                                             
 ; 

 ; Ŀ
 ;   Pur - the conductor.                                                  
 ; 
 (DEFUN C:PUR (/ blip esav snapp angbas cd thr ent1 pa ss ent2 pb typ1 typ2
                                                                       midd)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Initialize new error handler, turn off snap, etc.                     
 ; 
  (setq esav *error*)
  (setq *error* perox)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq angbas (getvar "angbase"))
  (setvar "angbase" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Make the first prompt string.                                         
 ; 
  (setq cd (getvar "cdate"))
  (setq thr (fix (* 100 (- cd (fix cd)))))
  (if (< 12 thr)
      (progn
           (if (< 17 thr)
               (setq thr "evening")
               (setq thr "afternoon")))
      (setq thr "morning"))
  (setq thr (strcat "Good " thr ", please select an entity: "))
 ; Ŀ
 ;   Prompt for two entities.                                              
 ; 
  (setq ent1 (car (setq pa (grizz thr))))                ; first ename
 ; Ŀ
 ;   If either the first entity selected was text, or there was nothing    
 ;   selected, get an ss of text and attdefs and branch off into Tea -     
 ;   text into a rectangle realigner.                                       
 ;   Note that must also call Tea if the first entity was a block and      
 ;   the second was a polyline, circle, arc, or nothing.                   
 ; 
  (if (or (null ent1)
          (= (cdr (assoc 0 (entget ent1))) "TEXT")
          (= (cdr (assoc 0 (entget ent1))) "ATTDEF"))
      (progn
           (setq ss (ssget '((-4 . "<or") (0 . "text")
                                          (0 . "attdef") (-4 . "or>"))))
           (cond ((and ent1 ss)
                  (ssadd ent1 ss))
                 (ent1 (setq ss (ssadd ent1))))
           (tea ss)))
 ; Ŀ
 ;   If there is no ss then we haven't called Tea and so need another      
 ;   entity.  Save the first pick point and get the second ename and pick  
 ;   point.                                                                
 ; 
  (if (null ss)
      (progn
           (setq pa (cadr pa))                                   ; 1st point
           (setq ent2 (car (setq pb (grizz "\nand another: "))))  ; 2nd ename
           (setq pb (cadr pb))))                                 ; & 2nd point
 ; Ŀ
 ;   Figure out what the entities were.                                    
 ; 
  (if ent1 (setq typ1 (cdr (assoc 0 (entget ent1)))))
  (if ent2 (setq typ2 (cdr (assoc 0 (entget ent2)))))
 ; Ŀ
 ;   Now call the appropriate subroutine.                                  
 ;   No first entity was selected and ss is nil so Tea wasn't called.      
 ; 
  (cond ((and (null ent1) (null ss))
         (prompt "\nNeed a first entity."))
 ; Ŀ
 ;   Make sure the same entity wasn't selected twice.                      
 ; 
        ((and ent1 ent2 (equal ent1 ent2))
         (prompt "\nThose were the same entity."))
 ; Ŀ
 ;   Make line perpendicular to a circle or move the circle to the end     
 ;   of the line, depending on which was picked first - as a general       
 ;   rule the first thing picked will be the one changed.                  
 ; 
        ((and (= typ1 "LINE") (member typ2 '("ARC" "CIRCLE")))
         (tanj pa ent1 ent2))
        ((and (member typ1 '("ARC" "CIRCLE")) (= typ2 "LINE"))
         (mcirc pb ent1 ent2))
 ; Ŀ
 ;   Make a line perpendicular to the largest circle in a block insertion. 
 ; 
        ((and (= typ1 "LINE") (= typ2 "INSERT"))
         (lins pa ent1 ent2))
 ; Ŀ
 ;   Make a leader perpendicular to the largest circle in a block insert.  
 ; 
        ((and (= typ1 "LEADER") (= typ2 "INSERT"))
         (leab pa ent1 ent2))
        ((and (= typ2 "LEADER") (= typ1 "INSERT"))
         (leab pa ent2 ent1))
 ; Ŀ
 ;   Make a leader perpendicular to a circle or an arc.                    
 ; 
        ((and (= typ1 "LEADER") (member typ2 '("CIRCLE" "ARC")))
         (erine pa ent1 ent2))
        ((and (= typ2 "LEADER") (member typ1 '("CIRCLE" "ARC")))
         (erine pa ent2 ent1))
 ; Ŀ
 ;   Move a block insertion to the end of a line.                          
 ; 
        ((and (= typ1 "INSERT") (= typ2 "LINE"))
         (blinc pb ent1 ent2))
 ; Ŀ
 ;   Move the closest end of a line to touch the point of an arrowhead,    
 ;   rotate the arrowhead to match the line angle.                         
 ; 
        ((and (= typ1 "LINE") (= typ2 "SOLID"))
         (larr ent1 ent2))
 ; Ŀ
 ;   Move an arrowhead to the closest end of a line and rotate it to       
 ;   match the line angle.                                                 
 ; 
        ((and (= typ1 "SOLID") (= typ2 "LINE"))
         (rarr ent1 ent2))
 ; Ŀ
 ;   Move one circle along a line between its centre and that of a second  
 ;   circle until they touch.                                              
 ; 
        ((and (= typ1 "CIRCLE") (= typ2 "CIRCLE"))
         (ctc ent1 ent2))
 ; Ŀ
 ;   Now come the Tea conditions for moving a block to the centre of       
 ;   another entity.                                                       
 ;   So: the first entity was a block and the second was nil, so want to   
 ;   move the block to the centre of a rectangular area defined by the     
 ;   point and another point which must be asked for.                      
 ; 
        ((and (or (= typ1 "INSERT") (= typ1 "CIRCLE")) (null ent2))
 ; Ŀ
 ;   The second entity was nil, so the second pick point must have been    
 ;   one corner of a box area.                                             
 ;   So get another corner and thus a centrepoint, make ent1 into an ss,   
 ;   call Mover to move it.                                                
 ; 
         (setq pa (getcorner pb "Other corner: "))
         (setq midd (polar pa (angle pa pb) (/ (distance pa pb) 2)))
         (setq pa (cdr (assoc 10 (entget ent1))))
         (mover pa midd ent1))
 ; Ŀ
 ;   The second entity was nil, so the second pick point must have been    
 ;   one corner of a box area.                                             
 ;   So get another corner and thus a centrepoint, make ent1 into an ss,   
 ;   call Mover to move it.                                                
 ; 
        ((and (or (= typ1 "INSERT") (= typ1 "CIRCLE"))
              (or (= typ2 "CIRCLE") (= typ2 "ARC")
                                    (= typ2 "POLYLINE")))
 ; Ŀ
 ;   Call AA to see if pb lay on 1. a circle, 2. a pline box or 3. an arc. 
 ;   If AA returns a centre point then move the block there, if not (the   
 ;   other options are an ename or nil) use pb as a base and get another   
 ;   corner, a centrepoint, call Mover, etc.                               
 ; 
         (if (= (type (setq midd (aa pb))) 'LIST)
             (progn
                  (setq pa (cdr (assoc 10 (entget ent1))))
                  (mover pa midd ent1))
             (progn
                  (setq pa (getcorner pb "Other corner: "))
                  (setq midd (polar pa (angle pa pb) (/ (distance pa pb) 2)))
                  (setq pa (cdr (assoc 10 (entget ent1))))
                  (mover pa midd ent1))))
 ; Ŀ
 ;   The second entity was a block: if it contains a circle, move the      
 ;   first entity to the centre thereof in that insertion.                 
 ; 
        ((and (= typ1 "INSERT") (= typ2 "INSERT"))
         (bzirk ent1 ent2))
 ; Ŀ
 ;   No usable entities were selected - a somewhat defeatist default.      
 ; 
        (T
         (if (null ss)
           (prompt "\nChange is bad, but that's ok: you haven't made any."))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (setvar "snapmode" snapp)
  (setvar "osmode" osmo)
  (setq *error* esav)
  (setvar "blipmode" blip)
  (command "undo" "end")
 (princ))